/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import jakarta.persistence.PersistenceException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportParameter;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportParameterRepository;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportParameterUsage;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportParameterUsageRepository;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportRepository;
import org.apache.fineract.infrastructure.dataqueries.exception.ReportNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.exception.ReportParameterNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.serialization.ReportCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.dataqueries.service.ReportWritePlatformService;
import org.apache.fineract.infrastructure.report.provider.ReportingProcessServiceProvider;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.domain.Permission;
import org.apache.fineract.useradministration.domain.PermissionRepository;
import org.apache.fineract.useradministration.exception.PermissionNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReportWritePlatformServiceImpl
implements ReportWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(ReportWritePlatformServiceImpl.class);
    private final PlatformSecurityContext context;
    private final ReportCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final ReportRepository reportRepository;
    private final ReportParameterUsageRepository reportParameterUsageRepository;
    private final ReportParameterRepository reportParameterRepository;
    private final PermissionRepository permissionRepository;
    private final ReportingProcessServiceProvider reportingProcessServiceProvider;

    @Autowired
    public ReportWritePlatformServiceImpl(PlatformSecurityContext context, ReportCommandFromApiJsonDeserializer fromApiJsonDeserializer, ReportRepository reportRepository, ReportParameterRepository reportParameterRepository, ReportParameterUsageRepository reportParameterUsageRepository, PermissionRepository permissionRepository, ReportingProcessServiceProvider reportingProcessServiceProvider) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.reportRepository = reportRepository;
        this.reportParameterRepository = reportParameterRepository;
        this.reportParameterUsageRepository = reportParameterUsageRepository;
        this.permissionRepository = permissionRepository;
        this.reportingProcessServiceProvider = reportingProcessServiceProvider;
    }

    @Transactional
    public CommandProcessingResult createReport(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validate(command.json());
            Report report = Report.fromJson((JsonCommand)command, (Collection)this.reportingProcessServiceProvider.findAllReportingTypes());
            Set reportParameterUsages = this.assembleSetOfReportParameterUsages(report, command);
            report.update(reportParameterUsages);
            this.reportRepository.saveAndFlush((Object)report);
            Permission permission = new Permission("report", report.getReportName(), "READ");
            this.permissionRepository.save((Object)permission);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)report.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleReportDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleReportDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateReport(Long reportId, JsonCommand command) {
        try {
            Set reportParameterUsages;
            boolean updated;
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validate(command.json());
            Report report = (Report)this.reportRepository.findById((Object)reportId).orElseThrow(() -> new ReportNotFoundException(reportId));
            Map changes = report.update(command, this.reportingProcessServiceProvider.findAllReportingTypes());
            if (changes.containsKey("reportParameters") && !(updated = report.update(reportParameterUsages = this.assembleSetOfReportParameterUsages(report, command)))) {
                changes.remove("reportParameters");
            }
            if (!changes.isEmpty()) {
                this.reportRepository.saveAndFlush((Object)report);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)report.getId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            this.handleReportDataIntegrityIssues(command, e.getMostSpecificCause(), (Exception)e);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException e) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)e.getCause());
            this.handleReportDataIntegrityIssues(command, throwable, (Exception)((Object)e));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult deleteReport(Long reportId) {
        Report report = (Report)this.reportRepository.findById((Object)reportId).orElseThrow(() -> new ReportNotFoundException(reportId));
        if (report.isCoreReport()) {
            throw new PlatformDataIntegrityException("error.msg.cant.delete.core.report", "Core Reports Can't be Deleted", "", new Object[0]);
        }
        Permission permission = this.permissionRepository.findOneByCode("READ_" + report.getReportName());
        if (permission == null) {
            throw new PermissionNotFoundException("READ_" + report.getReportName());
        }
        this.reportRepository.delete((Object)report);
        this.permissionRepository.delete((Object)permission);
        return new CommandProcessingResultBuilder().withEntityId(reportId).build();
    }

    private void handleReportDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("unq_report_name") || realCause.getMessage().contains("report_name_UNIQUE")) {
            String name = command.stringValueOfParameterNamed("reportName");
            throw new PlatformDataIntegrityException("error.msg.report.duplicate.name", "A report with name '" + name + "' already exists", "name", new Object[]{name});
        }
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.report.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    private Set<ReportParameterUsage> assembleSetOfReportParameterUsages(Report report, JsonCommand command) {
        JsonArray reportParametersArray;
        HashSet<ReportParameterUsage> reportParameterUsages = null;
        if (command.parameterExists("reportParameters") && (reportParametersArray = command.arrayOfParameterNamed("reportParameters")) != null) {
            reportParameterUsages = new HashSet<ReportParameterUsage>();
            for (int i = 0; i < reportParametersArray.size(); ++i) {
                String idStr;
                JsonObject jsonObject = reportParametersArray.get(i).getAsJsonObject();
                Long id = null;
                ReportParameterUsage reportParameterUsageItem = null;
                ReportParameter reportParameter = null;
                String reportParameterName = null;
                if (jsonObject.has("id") && StringUtils.isNotBlank((CharSequence)(idStr = jsonObject.get("id").getAsString()))) {
                    id = Long.parseLong(idStr);
                }
                if (id != null) {
                    reportParameterUsageItem = this.reportParameterUsageRepository.findById(id).orElse(null);
                    if (reportParameterUsageItem == null) {
                        throw new ReportParameterNotFoundException(id);
                    }
                    if (jsonObject.has("parameterId")) {
                        parameterId = jsonObject.get("parameterId").getAsLong();
                        reportParameter = (ReportParameter)this.reportParameterRepository.findById((Object)parameterId).orElseThrow(() -> new ReportParameterNotFoundException(parameterId));
                        if (!reportParameterUsageItem.hasParameterIdOf(parameterId)) {
                            throw new ReportParameterNotFoundException(parameterId);
                        }
                    }
                    if (jsonObject.has("reportParameterName")) {
                        reportParameterName = jsonObject.get("reportParameterName").getAsString();
                        reportParameterUsageItem.updateParameterName(reportParameterName);
                    }
                } else {
                    if (!jsonObject.has("parameterId")) {
                        throw new PlatformDataIntegrityException("error.msg.parameter.id.mandatory.in.report.parameter", "parameterId column is mandatory in Report Parameter Entry", new Object[0]);
                    }
                    parameterId = jsonObject.get("parameterId").getAsLong();
                    reportParameter = (ReportParameter)this.reportParameterRepository.findById((Object)parameterId).orElseThrow(() -> new ReportParameterNotFoundException(parameterId));
                    if (jsonObject.has("reportParameterName")) {
                        reportParameterName = jsonObject.get("reportParameterName").getAsString();
                    }
                    reportParameterUsageItem = new ReportParameterUsage(report, reportParameter, reportParameterName);
                }
                reportParameterUsages.add(reportParameterUsageItem);
            }
        }
        return reportParameterUsages;
    }
}

