/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.service;

import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureau;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauRepository;
import org.apache.fineract.infrastructure.creditbureau.domain.OrganisationCreditBureau;
import org.apache.fineract.infrastructure.creditbureau.domain.OrganisationCreditBureauRepository;
import org.apache.fineract.infrastructure.creditbureau.serialization.CreditBureauCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.creditbureau.service.OrganisationCreditBureauWritePlatflormService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrganisationCreditBureauWritePlatflormServiceImpl
implements OrganisationCreditBureauWritePlatflormService {
    private final PlatformSecurityContext context;
    private final OrganisationCreditBureauRepository organisationCreditBureauRepository;
    private final CreditBureauRepository creditBureauRepository;
    private final CreditBureauCommandFromApiJsonDeserializer fromApiJsonDeserializer;

    @Autowired
    public OrganisationCreditBureauWritePlatflormServiceImpl(PlatformSecurityContext context, OrganisationCreditBureauRepository organisationCreditBureauRepository, CreditBureauRepository creditBureauRepository, CreditBureauCommandFromApiJsonDeserializer fromApiJsonDeserializer) {
        this.context = context;
        this.organisationCreditBureauRepository = organisationCreditBureauRepository;
        this.creditBureauRepository = creditBureauRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }

    public CommandProcessingResult addOrganisationCreditBureau(Long creditBureauId, JsonCommand command) {
        this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateForCreate(command.json(), creditBureauId);
        CreditBureau creditBureau = (CreditBureau)this.creditBureauRepository.getReferenceById((Object)creditBureauId);
        OrganisationCreditBureau organisationCreditBureau = OrganisationCreditBureau.fromJson((JsonCommand)command, (CreditBureau)creditBureau);
        this.organisationCreditBureauRepository.saveAndFlush((Object)organisationCreditBureau);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)organisationCreditBureau.getId()).build();
    }

    @Transactional
    public CommandProcessingResult updateCreditBureau(JsonCommand command) {
        this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateForUpdate(command.json());
        long creditbureauID = command.longValueOfParameterNamed("creditBureauId");
        boolean isActive = command.booleanPrimitiveValueOfParameterNamed("isActive");
        OrganisationCreditBureau orgcb = (OrganisationCreditBureau)this.organisationCreditBureauRepository.getReferenceById((Object)creditbureauID);
        orgcb.setIsActive(isActive);
        this.organisationCreditBureauRepository.saveAndFlush((Object)orgcb);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)orgcb.getId()).build();
    }
}

