/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.service;

import jakarta.persistence.PersistenceException;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauConfigurations;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauReportData;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureau;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauRepository;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditReport;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditReportRepository;
import org.apache.fineract.infrastructure.creditbureau.service.CreditReportWritePlatformService;
import org.apache.fineract.infrastructure.creditbureau.service.ThitsaWorksCreditBureauIntegrationWritePlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditReportWritePlatformServiceImpl
implements CreditReportWritePlatformService {
    public static final String CREDIT_BUREAU_INTEGRATION = "creditBureauIntegration";
    public static final String CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED = "creditBureau.has.not.been.Integrated";
    private final PlatformSecurityContext context;
    private final CreditBureauRepository creditBureauRepository;
    private final CreditReportRepository creditReportRepository;
    private final ThitsaWorksCreditBureauIntegrationWritePlatformService thitsaWorksCreditBureauIntegrationWritePlatformService;

    @Autowired
    public CreditReportWritePlatformServiceImpl(PlatformSecurityContext context, CreditBureauRepository creditBureauRepository, CreditReportRepository creditReportRepository, ThitsaWorksCreditBureauIntegrationWritePlatformService thitsaWorksCreditBureauIntegrationWritePlatformService) {
        this.context = context;
        this.creditBureauRepository = creditBureauRepository;
        this.creditReportRepository = creditReportRepository;
        this.thitsaWorksCreditBureauIntegrationWritePlatformService = thitsaWorksCreditBureauIntegrationWritePlatformService;
    }

    @Transactional
    public CommandProcessingResult getCreditReport(JsonCommand command) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(CREDIT_BUREAU_INTEGRATION);
        try {
            Long creditBureauID = command.longValueOfParameterNamed("creditBureauID");
            String creditBureauName = this.getCreditBureauName(creditBureauID);
            if (Objects.equals(creditBureauName, CreditBureauConfigurations.THITSAWORKS.toString())) {
                CreditBureauReportData reportobj = this.thitsaWorksCreditBureauIntegrationWritePlatformService.getCreditReportFromThitsaWorks(command);
                Map<String, String[]> reportMap = Map.of("name", reportobj.getName(), "gender", reportobj.getGender(), "address", reportobj.getAddress(), "creditScore", reportobj.getCreditScore(), "borrowerInfo", reportobj.getBorrowerInfo(), "openAccounts", reportobj.getOpenAccounts(), "closedAccounts", reportobj.getClosedAccounts());
                return new CommandProcessingResultBuilder().withCreditReport(reportMap).build();
            }
            baseDataValidator.reset().failWithCode(CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, new Object[0]);
            throw new PlatformApiDataValidationException(CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, dataValidationErrors);
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleTokenDataIntegrityIssues(dve.getMostSpecificCause());
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException ee) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)ee.getCause());
            this.handleTokenDataIntegrityIssues(throwable);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public String addCreditReport(Long bureauId, File creditReport, FormDataContentDisposition fileDetail) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(CREDIT_BUREAU_INTEGRATION);
        String creditBureauName = this.getCreditBureauName(bureauId);
        String responseMessage = null;
        if (!Objects.equals(creditBureauName, CreditBureauConfigurations.THITSAWORKS.toString())) {
            baseDataValidator.reset().failWithCode(CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, new Object[0]);
            throw new PlatformApiDataValidationException(CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, dataValidationErrors);
        }
        responseMessage = this.thitsaWorksCreditBureauIntegrationWritePlatformService.addCreditReport(bureauId, creditReport, fileDetail);
        return responseMessage;
    }

    private String getCreditBureauName(Long creditBureauID) {
        Optional creditBureau;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(CREDIT_BUREAU_INTEGRATION);
        if (creditBureauID != null && !(creditBureau = this.creditBureauRepository.findById((Object)creditBureauID)).isEmpty()) {
            return ((CreditBureau)creditBureau.get()).getName();
        }
        baseDataValidator.reset().failWithCode(CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, new Object[0]);
        throw new PlatformApiDataValidationException(CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, CREDIT_BUREAU_HAS_NOT_BEEN_INTEGRATED, dataValidationErrors);
    }

    @Transactional
    public CommandProcessingResult saveCreditReport(Long creditBureauId, String nationalId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            String creditBureauName = this.getCreditBureauName(creditBureauId);
            CreditReport creditReport = null;
            if (Objects.equals(creditBureauName, CreditBureauConfigurations.THITSAWORKS.toString())) {
                creditReport = this.creditReportRepository.getThitsaWorksCreditReport(creditBureauId, nationalId);
                if (creditReport != null) {
                    this.creditReportRepository.delete((Object)creditReport);
                }
                String reportData = command.stringValueOfParameterNamed("apiRequestBodyAsJson");
                byte[] creditReportArray = reportData.getBytes(StandardCharsets.UTF_8);
                creditReport = CreditReport.instance((Long)creditBureauId, (String)nationalId, (byte[])creditReportArray);
                this.creditReportRepository.saveAndFlush((Object)creditReport);
            }
            return new CommandProcessingResultBuilder().withEntityId((Long)creditReport.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleTokenDataIntegrityIssues(dve.getMostSpecificCause());
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException ee) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)ee.getCause());
            this.handleTokenDataIntegrityIssues(throwable);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult deleteCreditReport(Long creditBureauId, JsonCommand command) {
        this.context.authenticatedUser();
        String creditBureauName = this.getCreditBureauName(creditBureauId);
        CreditReport creditReport = null;
        if (Objects.equals(creditBureauName, CreditBureauConfigurations.THITSAWORKS.toString())) {
            String nationalId = command.stringValueOfParameterNamed("nationalId");
            creditReport = this.creditReportRepository.getThitsaWorksCreditReport(creditBureauId, nationalId);
            try {
                this.creditReportRepository.delete((Object)creditReport);
            }
            catch (DataIntegrityViolationException | JpaSystemException dve) {
                throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.cund.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + dve.getMostSpecificCause().getMessage()));
            }
        }
        return new CommandProcessingResultBuilder().withEntityId((Long)creditReport.getId()).build();
    }

    private void handleTokenDataIntegrityIssues(Throwable realCause) {
        throw ErrorHandler.getMappable((Throwable)realCause, (String)"error.msg.cund.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }
}

