/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.serialization;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.configuration.exception.ExternalServiceConfigurationNotFoundException;
import org.apache.fineract.infrastructure.configuration.service.ExternalServicesConstants;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalServicesPropertiesCommandFromApiJsonDeserializer {
    private static final Set<String> S3_SUPPORTED_PARAMETERS = ExternalServicesConstants.S3JSONinputParams.getAllValues();
    private static final Set<String> SMTP_SUPPORTED_PARAMETERS = ExternalServicesConstants.SMTPJSONinputParams.getAllValues();
    private static final Set<String> SMS_SUPPORTED_PARAMETERS = ExternalServicesConstants.SMSJSONinputParams.getAllValues();
    private static final Set<String> NOTIFICATION_SUPPORTED_PARAMETERS = ExternalServicesConstants.NotificationJSONinputParams.getAllValues();
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public ExternalServicesPropertiesCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForUpdate(String json, String externalServiceName) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        switch (externalServiceName) {
            case "S3": {
                this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)S3_SUPPORTED_PARAMETERS);
                break;
            }
            case "SMTP": {
                this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SMTP_SUPPORTED_PARAMETERS);
                break;
            }
            case "SMS": {
                this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SMS_SUPPORTED_PARAMETERS);
                break;
            }
            case "NOTIFICATION": {
                this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)NOTIFICATION_SUPPORTED_PARAMETERS);
                break;
            }
            default: {
                throw new ExternalServiceConfigurationNotFoundException(externalServiceName);
            }
        }
    }

    public Set<String> getNameKeys(String json) {
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        Map jsonMap = this.fromApiJsonHelper.extractDataMap(typeOfMap, json);
        return jsonMap.keySet();
    }
}

