/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.jobs.sendmessagetosmsgateway;

import org.apache.fineract.infrastructure.campaigns.helper.SmsConfigUtils;
import org.apache.fineract.infrastructure.campaigns.jobs.sendmessagetosmsgateway.SendMessageToSmsGatewayTasklet;
import org.apache.fineract.infrastructure.gcm.service.NotificationSenderService;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SendMessageToSmsGatewayConfig {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private SmsMessageRepository smsMessageRepository;
    @Autowired
    private NotificationSenderService notificationSenderService;
    @Autowired
    private SmsConfigUtils smsConfigUtils;
    @Autowired
    @Qualifier(value="fineractDefaultThreadPoolTaskExecutor")
    private ThreadPoolTaskExecutor taskExecutor;

    @Bean
    protected Step sendMessageToSmsGatewayStep() {
        return new StepBuilder(JobName.SEND_MESSAGES_TO_SMS_GATEWAY.name(), this.jobRepository).tasklet((Tasklet)this.sendMessageToSmsGatewayTasklet(), this.transactionManager).build();
    }

    @Bean
    public Job sendMessageToSmsGatewayJob() {
        return ((SimpleJobBuilder)new JobBuilder(JobName.SEND_MESSAGES_TO_SMS_GATEWAY.name(), this.jobRepository).start(this.sendMessageToSmsGatewayStep()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }

    @Bean
    public SendMessageToSmsGatewayTasklet sendMessageToSmsGatewayTasklet() {
        return new SendMessageToSmsGatewayTasklet(this.smsMessageRepository, this.notificationSenderService, this.smsConfigUtils, this.taskExecutor);
    }
}

