/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll.vector;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildUtil;
import org.apache.druid.query.aggregation.datasketches.hll.vector.HllSketchBuildVectorProcessor;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class SingleValueStringHllSketchBuildVectorProcessor
implements HllSketchBuildVectorProcessor {
    private final HllSketchBuildBufferAggregatorHelper helper;
    private final StringEncoding stringEncoding;
    private final SingleValueDimensionVectorSelector selector;

    public SingleValueStringHllSketchBuildVectorProcessor(HllSketchBuildBufferAggregatorHelper helper, StringEncoding stringEncoding, SingleValueDimensionVectorSelector selector) {
        this.helper = helper;
        this.stringEncoding = stringEncoding;
        this.selector = selector;
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        int[] vector = this.selector.getRowVector();
        HllSketch sketch = this.helper.getSketchAtPosition(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            HllSketchBuildUtil.updateSketchWithDictionarySelector(sketch, this.stringEncoding, (DimensionDictionarySelector)this.selector, vector[i]);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        int[] vector = this.selector.getRowVector();
        for (int i = 0; i < numRows; ++i) {
            int idx = rows != null ? rows[i] : i;
            int position = positions[i] + positionOffset;
            HllSketch sketch = this.helper.getSketchAtPosition(buf, position);
            HllSketchBuildUtil.updateSketchWithDictionarySelector(sketch, this.stringEncoding, (DimensionDictionarySelector)this.selector, vector[idx]);
        }
    }
}

