/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll.vector;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildUtil;
import org.apache.druid.query.aggregation.datasketches.hll.vector.HllSketchBuildVectorProcessor;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class ObjectHllSketchBuildVectorProcessor
implements HllSketchBuildVectorProcessor {
    private final HllSketchBuildBufferAggregatorHelper helper;
    private final StringEncoding stringEncoding;
    private final VectorObjectSelector selector;

    public ObjectHllSketchBuildVectorProcessor(HllSketchBuildBufferAggregatorHelper helper, StringEncoding stringEncoding, VectorObjectSelector selector) {
        this.helper = helper;
        this.stringEncoding = stringEncoding;
        this.selector = selector;
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        Object[] vector = this.selector.getObjectVector();
        HllSketch sketch = this.helper.getSketchAtPosition(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            if (vector[i] == null) continue;
            HllSketchBuildUtil.updateSketch(sketch, this.stringEncoding, vector[i]);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.selector.getObjectVector();
        for (int i = 0; i < numRows; ++i) {
            int idx = rows != null ? rows[i] : i;
            int position = positions[i] + positionOffset;
            HllSketch sketch = this.helper.getSketchAtPosition(buf, position);
            if (vector[idx] == null) continue;
            HllSketchBuildUtil.updateSketch(sketch, this.stringEncoding, vector[idx]);
        }
    }
}

