/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.azure.storage.blob.models.BlobStorageException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureDataSegmentConfig;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;
import org.apache.druid.timeline.DataSegment;

public class AzureDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(AzureDataSegmentKiller.class);
    private final AzureDataSegmentConfig segmentConfig;
    private final AzureInputDataConfig inputDataConfig;
    private final AzureAccountConfig accountConfig;
    private final AzureStorage azureStorage;
    private final AzureCloudBlobIterableFactory azureCloudBlobIterableFactory;

    @Inject
    public AzureDataSegmentKiller(AzureDataSegmentConfig segmentConfig, AzureInputDataConfig inputDataConfig, AzureAccountConfig accountConfig, @Global AzureStorage azureStorage, AzureCloudBlobIterableFactory azureCloudBlobIterableFactory) {
        this.segmentConfig = segmentConfig;
        this.inputDataConfig = inputDataConfig;
        this.accountConfig = accountConfig;
        this.azureStorage = azureStorage;
        this.azureCloudBlobIterableFactory = azureCloudBlobIterableFactory;
    }

    public void kill(List<DataSegment> segments) throws SegmentLoadingException {
        if (segments.isEmpty()) {
            return;
        }
        if (segments.size() == 1) {
            this.kill(segments.get(0));
            return;
        }
        HashMap<String, List> containerToKeysToDelete = new HashMap<String, List>();
        for (DataSegment segment : segments) {
            Map loadSpec = segment.getLoadSpec();
            String containerName = MapUtils.getString((Map)loadSpec, (String)"containerName");
            String blobPath = MapUtils.getString((Map)loadSpec, (String)"blobPath");
            List keysToDelete = containerToKeysToDelete.computeIfAbsent(containerName, k -> new ArrayList());
            keysToDelete.add(blobPath);
        }
        boolean shouldThrowException = false;
        for (Map.Entry containerToKeys : containerToKeysToDelete.entrySet()) {
            boolean batchSuccessful = this.azureStorage.batchDeleteFiles((String)containerToKeys.getKey(), (Iterable)containerToKeys.getValue(), null);
            if (batchSuccessful) continue;
            shouldThrowException = true;
        }
        if (shouldThrowException) {
            throw new SegmentLoadingException("Couldn't delete segments from Azure. See the task logs for more details.", new Object[0]);
        }
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        log.info("Killing segment [%s]", new Object[]{segment});
        Map loadSpec = segment.getLoadSpec();
        String containerName = MapUtils.getString((Map)loadSpec, (String)"containerName");
        String blobPath = MapUtils.getString((Map)loadSpec, (String)"blobPath");
        String dirPath = Paths.get(blobPath, new String[0]).getParent().toString();
        try {
            this.azureStorage.emptyCloudBlobDirectory(containerName, dirPath);
        }
        catch (BlobStorageException e) {
            throw new SegmentLoadingException((Throwable)e, "Couldn't kill segment[%s]: [%s]", new Object[]{segment.getId(), e.getMessage()});
        }
    }

    public void killAll() throws IOException {
        if (this.segmentConfig.getContainer() == null || this.segmentConfig.getPrefix() == null) {
            throw new ISE("Cannot delete all segment files since Azure Deep Storage since druid.azure.container and druid.azure.prefix are not both set.", new Object[0]);
        }
        log.info("Deleting all segment files from Azure storage location [bucket: '%s' prefix: '%s']", new Object[]{this.segmentConfig.getContainer(), this.segmentConfig.getPrefix()});
        try {
            AzureUtils.deleteObjectsInPath(this.azureStorage, this.inputDataConfig, this.accountConfig, this.azureCloudBlobIterableFactory, this.segmentConfig.getContainer(), this.segmentConfig.getPrefix(), (Predicate<CloudBlobHolder>)Predicates.alwaysTrue());
        }
        catch (Exception e) {
            log.error("Error occurred while deleting segment files from Azure. Error: %s", new Object[]{e.getMessage()});
            throw new IOException(e);
        }
    }
}

