/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ISCSIVolumeSource;
import io.kubernetes.client.openapi.models.V1ISCSIVolumeSourceFluent;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ISCSIVolumeSourceFluentImpl<A extends V1ISCSIVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1ISCSIVolumeSourceFluent<A> {
    private Boolean chapAuthDiscovery;
    private Boolean chapAuthSession;
    private String fsType;
    private String initiatorName;
    private String iqn;
    private String iscsiInterface;
    private Integer lun;
    private List<String> portals;
    private Boolean readOnly;
    private V1LocalObjectReferenceBuilder secretRef;
    private String targetPortal;

    public V1ISCSIVolumeSourceFluentImpl() {
    }

    public V1ISCSIVolumeSourceFluentImpl(V1ISCSIVolumeSource instance) {
        if (instance != null) {
            this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
            this.withChapAuthSession(instance.getChapAuthSession());
            this.withFsType(instance.getFsType());
            this.withInitiatorName(instance.getInitiatorName());
            this.withIqn(instance.getIqn());
            this.withIscsiInterface(instance.getIscsiInterface());
            this.withLun(instance.getLun());
            this.withPortals(instance.getPortals());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withTargetPortal(instance.getTargetPortal());
        }
    }

    @Override
    public Boolean getChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    @Override
    public A withChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthDiscovery() {
        return this.chapAuthDiscovery != null;
    }

    @Override
    public Boolean getChapAuthSession() {
        return this.chapAuthSession;
    }

    @Override
    public A withChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthSession() {
        return this.chapAuthSession != null;
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public A withInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
        return (A)this;
    }

    @Override
    public Boolean hasInitiatorName() {
        return this.initiatorName != null;
    }

    @Override
    public String getIqn() {
        return this.iqn;
    }

    @Override
    public A withIqn(String iqn) {
        this.iqn = iqn;
        return (A)this;
    }

    @Override
    public Boolean hasIqn() {
        return this.iqn != null;
    }

    @Override
    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    @Override
    public A withIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return (A)this;
    }

    @Override
    public Boolean hasIscsiInterface() {
        return this.iscsiInterface != null;
    }

    @Override
    public Integer getLun() {
        return this.lun;
    }

    @Override
    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    @Override
    public Boolean hasLun() {
        return this.lun != null;
    }

    @Override
    public A addToPortals(int index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPortals(int index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPortals(String ... items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPortals(Collection<String> items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortals(String ... items) {
        for (String item : items) {
            if (this.portals == null) continue;
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPortals(Collection<String> items) {
        for (String item : items) {
            if (this.portals == null) continue;
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPortals() {
        return this.portals;
    }

    @Override
    public String getPortal(int index) {
        return this.portals.get(index);
    }

    @Override
    public String getFirstPortal() {
        return this.portals.get(0);
    }

    @Override
    public String getLastPortal() {
        return this.portals.get(this.portals.size() - 1);
    }

    @Override
    public String getMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPortals(List<String> portals) {
        if (portals != null) {
            this.portals = new ArrayList<String>();
            for (String item : portals) {
                this.addToPortals(item);
            }
        } else {
            this.portals = null;
        }
        return (A)this;
    }

    @Override
    public A withPortals(String ... portals) {
        if (this.portals != null) {
            this.portals.clear();
            this._visitables.remove("portals");
        }
        if (portals != null) {
            for (String item : portals) {
                this.addToPortals(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPortals() {
        return this.portals != null && !this.portals.isEmpty();
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public V1LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(V1LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new V1LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public V1ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public V1ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public V1ISCSIVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public V1ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new V1LocalObjectReferenceBuilder().build());
    }

    @Override
    public V1ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getTargetPortal() {
        return this.targetPortal;
    }

    @Override
    public A withTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return (A)this;
    }

    @Override
    public Boolean hasTargetPortal() {
        return this.targetPortal != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ISCSIVolumeSourceFluentImpl that = (V1ISCSIVolumeSourceFluentImpl)o;
        if (!Objects.equals(this.chapAuthDiscovery, that.chapAuthDiscovery)) {
            return false;
        }
        if (!Objects.equals(this.chapAuthSession, that.chapAuthSession)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.initiatorName, that.initiatorName)) {
            return false;
        }
        if (!Objects.equals(this.iqn, that.iqn)) {
            return false;
        }
        if (!Objects.equals(this.iscsiInterface, that.iscsiInterface)) {
            return false;
        }
        if (!Objects.equals(this.lun, that.lun)) {
            return false;
        }
        if (!Objects.equals(this.portals, that.portals)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        return Objects.equals(this.targetPortal, that.targetPortal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.chapAuthDiscovery, this.chapAuthSession, this.fsType, this.initiatorName, this.iqn, this.iscsiInterface, this.lun, this.portals, this.readOnly, this.secretRef, this.targetPortal, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.chapAuthDiscovery != null) {
            sb.append("chapAuthDiscovery:");
            sb.append(this.chapAuthDiscovery + ",");
        }
        if (this.chapAuthSession != null) {
            sb.append("chapAuthSession:");
            sb.append(this.chapAuthSession + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.initiatorName != null) {
            sb.append("initiatorName:");
            sb.append(this.initiatorName + ",");
        }
        if (this.iqn != null) {
            sb.append("iqn:");
            sb.append(this.iqn + ",");
        }
        if (this.iscsiInterface != null) {
            sb.append("iscsiInterface:");
            sb.append(this.iscsiInterface + ",");
        }
        if (this.lun != null) {
            sb.append("lun:");
            sb.append(this.lun + ",");
        }
        if (this.portals != null && !this.portals.isEmpty()) {
            sb.append("portals:");
            sb.append(this.portals + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.targetPortal != null) {
            sb.append("targetPortal:");
            sb.append(this.targetPortal);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withChapAuthDiscovery() {
        return this.withChapAuthDiscovery(true);
    }

    @Override
    public A withChapAuthSession() {
        return this.withChapAuthSession(true);
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class SecretRefNestedImpl<N>
    extends V1LocalObjectReferenceFluentImpl<V1ISCSIVolumeSourceFluent.SecretRefNested<N>>
    implements V1ISCSIVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        V1LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(V1LocalObjectReference item) {
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new V1LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ISCSIVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

