/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceAllocationConfiguration;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.OpaqueDeviceConfiguration;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.OpaqueDeviceConfigurationBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.OpaqueDeviceConfigurationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DeviceAllocationConfigurationFluent<A extends DeviceAllocationConfigurationFluent<A>>
extends BaseFluent<A> {
    private OpaqueDeviceConfigurationBuilder opaque;
    private List<String> requests = new ArrayList<String>();
    private String source;
    private Map<String, Object> additionalProperties;

    public DeviceAllocationConfigurationFluent() {
    }

    public DeviceAllocationConfigurationFluent(DeviceAllocationConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeviceAllocationConfiguration instance) {
        DeviceAllocationConfiguration deviceAllocationConfiguration = instance = instance != null ? instance : new DeviceAllocationConfiguration();
        if (instance != null) {
            this.withOpaque(instance.getOpaque());
            this.withRequests(instance.getRequests());
            this.withSource(instance.getSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public OpaqueDeviceConfiguration buildOpaque() {
        return this.opaque != null ? this.opaque.build() : null;
    }

    public A withOpaque(OpaqueDeviceConfiguration opaque) {
        this._visitables.remove((Object)"opaque");
        if (opaque != null) {
            this.opaque = new OpaqueDeviceConfigurationBuilder(opaque);
            this._visitables.get((Object)"opaque").add(this.opaque);
        } else {
            this.opaque = null;
            this._visitables.get((Object)"opaque").remove((Object)this.opaque);
        }
        return (A)((Object)this);
    }

    public boolean hasOpaque() {
        return this.opaque != null;
    }

    public A withNewOpaque(String driver, Object parameters) {
        return this.withOpaque(new OpaqueDeviceConfiguration(driver, parameters));
    }

    public OpaqueNested<A> withNewOpaque() {
        return new OpaqueNested(null);
    }

    public OpaqueNested<A> withNewOpaqueLike(OpaqueDeviceConfiguration item) {
        return new OpaqueNested(item);
    }

    public OpaqueNested<A> editOpaque() {
        return this.withNewOpaqueLike(Optional.ofNullable(this.buildOpaque()).orElse(null));
    }

    public OpaqueNested<A> editOrNewOpaque() {
        return this.withNewOpaqueLike(Optional.ofNullable(this.buildOpaque()).orElse(new OpaqueDeviceConfigurationBuilder().build()));
    }

    public OpaqueNested<A> editOrNewOpaqueLike(OpaqueDeviceConfiguration item) {
        return this.withNewOpaqueLike(Optional.ofNullable(this.buildOpaque()).orElse(item));
    }

    public A addToRequests(int index, String item) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.add(index, item);
        return (A)((Object)this);
    }

    public A setToRequests(int index, String item) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.set(index, item);
        return (A)((Object)this);
    }

    public A addToRequests(String ... items) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        for (String item : items) {
            this.requests.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRequests(Collection<String> items) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        for (String item : items) {
            this.requests.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRequests(String ... items) {
        if (this.requests == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.requests.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRequests(Collection<String> items) {
        if (this.requests == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.requests.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getRequests() {
        return this.requests;
    }

    public String getRequest(int index) {
        return this.requests.get(index);
    }

    public String getFirstRequest() {
        return this.requests.get(0);
    }

    public String getLastRequest() {
        return this.requests.get(this.requests.size() - 1);
    }

    public String getMatchingRequest(Predicate<String> predicate) {
        for (String item : this.requests) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequest(Predicate<String> predicate) {
        for (String item : this.requests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequests(List<String> requests) {
        if (requests != null) {
            this.requests = new ArrayList<String>();
            for (String item : requests) {
                this.addToRequests(item);
            }
        } else {
            this.requests = null;
        }
        return (A)((Object)this);
    }

    public A withRequests(String ... requests) {
        if (this.requests != null) {
            this.requests.clear();
            this._visitables.remove((Object)"requests");
        }
        if (requests != null) {
            for (String item : requests) {
                this.addToRequests(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRequests() {
        return this.requests != null && !this.requests.isEmpty();
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceAllocationConfigurationFluent that = (DeviceAllocationConfigurationFluent)((Object)o);
        if (!Objects.equals((Object)this.opaque, (Object)that.opaque)) {
            return false;
        }
        if (!Objects.equals(this.requests, that.requests)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.opaque, this.requests, this.source, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.opaque != null) {
            sb.append("opaque:");
            sb.append(String.valueOf((Object)this.opaque) + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(String.valueOf(this.requests) + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OpaqueNested<N>
    extends OpaqueDeviceConfigurationFluent<OpaqueNested<N>>
    implements Nested<N> {
        OpaqueDeviceConfigurationBuilder builder;

        OpaqueNested(OpaqueDeviceConfiguration item) {
            this.builder = new OpaqueDeviceConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)DeviceAllocationConfigurationFluent.this.withOpaque(this.builder.build());
        }

        public N endOpaque() {
            return this.and();
        }
    }
}

