/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public enum KinesisRegion {
    US_EAST_2,
    US_EAST_1,
    US_WEST_1,
    US_WEST_2,
    AP_NORTHEAST_1,
    AP_NORTHEAST_2,
    AP_NORTHEAST_3,
    AP_SOUTH_1,
    AP_SOUTHEAST_1,
    AP_SOUTHEAST_2,
    CA_CENTRAL_1,
    CN_NORTH_1,
    CN_NORTHWEST_1,
    EU_CENTRAL_1,
    EU_WEST_1,
    EU_WEST_2,
    EU_WEST_3,
    SA_EAST_1,
    US_GOV_WEST_1;


    @JsonCreator
    public static KinesisRegion fromString(String value) {
        return EnumSet.allOf(KinesisRegion.class).stream().filter(x -> x.serialize().equals(value)).findFirst().orElseThrow(() -> new IAE("Invalid region %s, region must be one of: %s", new Object[]{value, KinesisRegion.getNames()}));
    }

    private static List<String> getNames() {
        return EnumSet.allOf(KinesisRegion.class).stream().map(KinesisRegion::serialize).collect(Collectors.toList());
    }

    public String getEndpoint() {
        return StringUtils.format((String)"kinesis.%s.amazonaws.com%s", (Object[])new Object[]{this.serialize(), this.serialize().startsWith("cn-") ? ".cn" : ""});
    }

    @JsonValue
    public String serialize() {
        return StringUtils.toLowerCase((String)this.name()).replace('_', '-');
    }
}

