/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.NativeRegExpInstantiator;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

class NativeRegExpCtor {
    private static final long serialVersionUID = -5733330028285400526L;

    NativeRegExpCtor() {
    }

    public static LambdaConstructor init(Context cx, Scriptable scopeArg, boolean sealed) {
        ScriptableObject scope = (ScriptableObject)scopeArg;
        LambdaConstructor ctor = new LambdaConstructor((Scriptable)scope, "RegExp", 2, NativeRegExpCtor::js_constructCall, NativeRegExpCtor::js_construct);
        ctor.defineProperty(cx, "multiline", c -> ScriptRuntime.wrapBoolean(NativeRegExpCtor.getImpl().multiline), (c, v) -> {
            NativeRegExpCtor.getImpl().multiline = ScriptRuntime.toBoolean(v);
        }, 4);
        ctor.defineProperty(cx, "$*", c -> ScriptRuntime.wrapBoolean(NativeRegExpCtor.getImpl().multiline), (c, v) -> {
            NativeRegExpCtor.getImpl().multiline = ScriptRuntime.toBoolean(v);
        }, 4);
        ctor.defineProperty(cx, "input", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().input), (c, v) -> {
            NativeRegExpCtor.getImpl().input = ScriptRuntime.toString(v);
        }, 4);
        ctor.defineProperty(cx, "$_", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().input), (c, v) -> {
            NativeRegExpCtor.getImpl().input = ScriptRuntime.toString(v);
        }, 4);
        ctor.defineProperty(cx, "lastMatch", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().lastMatch), 4);
        ctor.defineProperty(cx, "$&", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().lastMatch), 4);
        ctor.defineProperty(cx, "lastParen", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().lastParen), 4);
        ctor.defineProperty(cx, "$+", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().lastParen), 4);
        ctor.defineProperty(cx, "leftContext", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().leftContext), 4);
        ctor.defineProperty(cx, "$`", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().leftContext), 4);
        ctor.defineProperty(cx, "rightContext", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().rightContext), 4);
        ctor.defineProperty(cx, "$'", c -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().rightContext), 4);
        for (int i = 1; i < 10; ++i) {
            int c2 = i - 1;
            ctor.defineProperty(cx, String.format("$%d", i), x -> NativeRegExpCtor.toStr(NativeRegExpCtor.getImpl().getParenSubString(c2)), null, 4);
        }
        return ctor;
    }

    private static String toStr(String subStr) {
        return subStr == null ? "" : subStr;
    }

    private static String toStr(SubString subStr) {
        return subStr == null ? "" : subStr.toString();
    }

    private static Scriptable js_constructCall(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length > 0 && args[0] instanceof NativeRegExp && (args.length == 1 || args[1] == Undefined.instance)) {
            return (Scriptable)args[0];
        }
        return NativeRegExpCtor.js_construct(cx, scope, args);
    }

    private static Scriptable js_construct(Context cx, Scriptable scope, Object[] args) {
        NativeRegExp re = NativeRegExpInstantiator.withLanguageVersion(cx.getLanguageVersion());
        re.compile(cx, scope, args);
        ScriptRuntime.setBuiltinProtoAndParent(re, scope, TopLevel.Builtins.RegExp);
        return re;
    }

    private static RegExpImpl getImpl() {
        Context cx = Context.getCurrentContext();
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(cx);
    }
}

