/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;

public class BasicHttpClientSecurityConfiguration
implements HttpClientSecurityConfiguration {
    @Nullable
    private CredentialsProvider credentialsProvider;
    @Nullable
    private Map<HttpHost, UsernamePasswordCredentials> preemptiveBasicAuthMap;
    @Nullable
    private TrustEngine<? super X509Credential> tlsTrustEngine;
    @Nullable
    private List<String> tlsProtocols;
    @Nullable
    private List<String> tlsCipherSuites;
    @Nullable
    private HostnameVerifier hostnameVerifier;
    @Nullable
    private X509Credential clientTLSCredential;
    @Nullable
    private Boolean serverTLSFailureFatal;

    @Nullable
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setCredentialsProvider(@Nullable CredentialsProvider provider) {
        this.credentialsProvider = provider;
        return this;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    public Map<HttpHost, UsernamePasswordCredentials> getPreemptiveBasicAuthMap() {
        return this.preemptiveBasicAuthMap;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setPreemptiveBasicAuthMap(@Nullable Map<HttpHost, UsernamePasswordCredentials> map) {
        this.preemptiveBasicAuthMap = map != null ? CollectionSupport.copyToMap(map) : null;
        return this;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setBasicCredentials(@Nullable UsernamePasswordCredentials credentials) {
        this.setBasicCredentialsWithScope(credentials, null);
        return this;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setBasicCredentialsWithScope(@Nullable UsernamePasswordCredentials credentials, @Nullable AuthScope scope) {
        if (credentials != null) {
            AuthScope authScope = scope;
            if (authScope == null) {
                authScope = new AuthScope(null, -1);
            }
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(authScope, (Credentials)credentials);
            this.credentialsProvider = provider;
        } else {
            this.credentialsProvider = null;
        }
        return this;
    }

    @Nullable
    public TrustEngine<? super X509Credential> getTLSTrustEngine() {
        return this.tlsTrustEngine;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setTLSTrustEngine(@Nullable TrustEngine<? super X509Credential> engine) {
        this.tlsTrustEngine = engine;
        return this;
    }

    @Nullable
    public List<String> getTLSProtocols() {
        return this.tlsProtocols;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setTLSProtocols(@Nullable Collection<String> protocols) {
        this.tlsProtocols = CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(protocols));
        if (this.tlsProtocols.isEmpty()) {
            this.tlsProtocols = null;
        }
        return this;
    }

    @Nullable
    public List<String> getTLSCipherSuites() {
        return this.tlsCipherSuites;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setTLSCipherSuites(@Nullable Collection<String> cipherSuites) {
        this.tlsCipherSuites = CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(cipherSuites));
        if (this.tlsCipherSuites.isEmpty()) {
            this.tlsCipherSuites = null;
        }
        return this;
    }

    @Nullable
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setHostnameVerifier(@Nullable HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
        return this;
    }

    @Nullable
    public X509Credential getClientTLSCredential() {
        return this.clientTLSCredential;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setClientTLSCredential(@Nullable X509Credential credential) {
        this.clientTLSCredential = credential;
        return this;
    }

    @Nullable
    public Boolean isServerTLSFailureFatal() {
        return this.serverTLSFailureFatal;
    }

    @Nonnull
    public BasicHttpClientSecurityConfiguration setServerTLSFailureFatal(@Nullable Boolean flag) {
        this.serverTLSFailureFatal = flag;
        return this;
    }
}

