#!/bin/sh -ex
# Licensed under the Apache License, Version 2.0 (the "License"); you may not
# use this file except in compliance with the License. You may obtain a copy of
# the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations under
# the License.

echo "To test, comment out the fake_uuid line in dev/run"

HEADERS="-HContent-Type:application/json"
# show cluster state:
curl a:b@127.0.0.1:15986/_nodes/_all_docs

# Enable Cluster on node A
curl a:b@127.0.0.1:15984/_cluster_setup -d '{"action":"enable_cluster","username":"foo","password":"baz","bind_address":"0.0.0.0","node_count":2}' $HEADERS

# Enable Cluster on node B
curl a:b@127.0.0.1:15984/_cluster_setup -d '{"action":"enable_cluster","remote_node":"127.0.0.1","port":"25984","remote_current_user":"a","remote_current_password":"b","username":"foo","password":"baz","bind_address":"0.0.0.0","node_count":2}' $HEADERS

# Add node B on node A
curl a:b@127.0.0.1:15984/_cluster_setup -d '{"action":"add_node","username":"foo","password":"baz","host":"127.0.0.1","port":25984,"name":"node2"}' $HEADERS

# Show cluster state:
curl a:b@127.0.0.1:15986/_nodes/_all_docs

# Show db doesn’t exist on node A
curl a:b@127.0.0.1:15984/foo

# Show db doesn’t exist on node B
curl a:b@127.0.0.1:25984/foo

# Create database (on node A)
curl -X PUT a:b@127.0.0.1:15984/foo

# Show db does exist on node A
curl a:b@127.0.0.1:15984/foo

# Show db does exist on node B
curl a:b@127.0.0.1:25984/foo

# Finish cluster
curl a:b@127.0.0.1:15984/_cluster_setup -d '{"action":"finish_cluster"}' $HEADERS

# Show system dbs exist on node A
curl a:b@127.0.0.1:15984/_users
curl a:b@127.0.0.1:15984/_replicator
curl a:b@127.0.0.1:15984/_global_changes

# Show system dbs exist on node B
curl a:b@127.0.0.1:25984/_users
curl a:b@127.0.0.1:25984/_replicator
curl a:b@127.0.0.1:25984/_global_changes

# Number of nodes is set to 2
curl a:b@127.0.0.1:25984/_node/node2@127.0.0.1/_config/cluster/n

# uuid and auth secret are the same
curl a:b@127.0.0.1:15984/_node/node1@127.0.0.1/_config/couchdb/uuid
curl a:b@127.0.0.1:15984/_node/node2@127.0.0.1/_config/couchdb/uuid

curl a:b@127.0.0.1:15984/_node/node1@127.0.0.1/_config/chttpd_auth/secret
curl a:b@127.0.0.1:15984/_node/node2@127.0.0.1/_config/chttpd_auth/secret


echo "YAY ALL GOOD"
