/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.apache.commons.io.input.ThrottledInputStream;
import org.apache.commons.io.test.CustomIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThrottledInputStreamTest
extends ProxyInputStreamTest<ThrottledInputStream> {
    ThrottledInputStreamTest() {
    }

    @Override
    protected ThrottledInputStream createFixture() throws IOException {
        return ((ThrottledInputStream.Builder)ThrottledInputStream.builder().setInputStream(this.createOriginInputStream())).get();
    }

    @Test
    void testAfterReadConsumer() throws Exception {
        AtomicBoolean boolRef = new AtomicBoolean();
        try (ThrottledInputStream bounded = ((ThrottledInputStream.Builder)((ThrottledInputStream.Builder)ThrottledInputStream.builder().setCharSequence((CharSequence)"Hi")).setAfterRead(i -> boolRef.set(true))).get();){
            IOUtils.consume((InputStream)bounded);
        }
        Assertions.assertTrue((boolean)boolRef.get());
        String message = "test exception message";
        try (ThrottledInputStream inputStream = ((ThrottledInputStream.Builder)((ThrottledInputStream.Builder)ThrottledInputStream.builder().setCharSequence((CharSequence)"Hi")).setAfterRead(i -> {
            throw new CustomIOException("test exception message");
        })).get();){
            Assertions.assertEquals((Object)"test exception message", (Object)((CustomIOException)Assertions.assertThrowsExactly(CustomIOException.class, () -> ThrottledInputStreamTest.lambda$testAfterReadConsumer$2((InputStream)inputStream))).getMessage());
        }
    }

    @Test
    void testBuilder() throws IOException {
        ThrottledInputStream.Builder builder = ThrottledInputStream.builder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.setMaxBytesPerSecond(-1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.setMaxBytesPerSecond(0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.setMaxBytes(1L, Duration.ZERO.minusMillis(1L)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.setMaxBytes(1L, Duration.ZERO));
        Assertions.assertThrows(NullPointerException.class, () -> builder.setMaxBytes(1L, (Duration)null));
        Assertions.assertThrows(NullPointerException.class, () -> builder.setMaxBytes(1L, (ChronoUnit)null));
        builder.setMaxBytesPerSecond(2L);
        Assertions.assertEquals((double)2.0, (double)builder.getMaxBytesPerSecond());
        try (ThrottledInputStream inputStream = ((ThrottledInputStream.Builder)builder.setInputStream(this.createOriginInputStream())).get();){
            Assertions.assertEquals((double)2.0, (double)builder.getMaxBytesPerSecond());
            Assertions.assertEquals((double)2.0, (double)inputStream.getMaxBytesPerSecond());
        }
        inputStream = ((ThrottledInputStream.Builder)builder.setInputStream(this.createOriginInputStream())).setMaxBytes(2L, ChronoUnit.SECONDS).get();
        try {
            Assertions.assertEquals((double)2.0, (double)builder.getMaxBytesPerSecond());
            Assertions.assertEquals((double)2.0, (double)inputStream.getMaxBytesPerSecond());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        Duration maxBytesPer = Duration.ofSeconds(1L);
        try (ThrottledInputStream inputStream = ((ThrottledInputStream.Builder)builder.setInputStream(this.createOriginInputStream())).setMaxBytes(2L, maxBytesPer).get();){
            Assertions.assertEquals((double)2.0, (double)builder.getMaxBytesPerSecond());
            Assertions.assertEquals((double)2.0, (double)inputStream.getMaxBytesPerSecond());
        }
        maxBytesPer = maxBytesPer.dividedBy(2L);
        inputStream = ((ThrottledInputStream.Builder)builder.setInputStream(this.createOriginInputStream())).setMaxBytes(1L, maxBytesPer).get();
        try {
            Assertions.assertEquals((double)0.5, (double)inputStream.getMaxBytesPerSecond());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        inputStream = ((ThrottledInputStream.Builder)builder.setInputStream(this.createOriginInputStream())).setMaxBytes(1L, ChronoUnit.MILLIS).get();
        try {
            Assertions.assertEquals((double)0.001, (double)inputStream.getMaxBytesPerSecond());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        maxBytesPer = Duration.ofSeconds(20L).plusMillis(11L);
        inputStream = ((ThrottledInputStream.Builder)builder.setInputStream(this.createOriginInputStream())).setMaxBytes(1L, maxBytesPer).get();
        try {
            Assertions.assertEquals((double)20.011, (double)inputStream.getMaxBytesPerSecond());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        inputStream = ((ThrottledInputStream.Builder)builder.setInputStream(this.createOriginInputStream())).setMaxBytes(100000L, ChronoUnit.SECONDS).get();
        try {
            Assertions.assertEquals((double)100000.0, (double)inputStream.getMaxBytesPerSecond());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Test
    void testCalSleepTimeMs() {
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)0L, (long)1000L, (double)10000.0));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)Long.MAX_VALUE, (long)1000L, (double)0.0));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)Long.MAX_VALUE, (long)1000L, (double)-1.0));
        Assertions.assertEquals((long)1500L, (long)ThrottledInputStream.toSleepMillis((long)5L, (long)1000L, (double)2.0));
        Assertions.assertEquals((long)500L, (long)ThrottledInputStream.toSleepMillis((long)5L, (long)2000L, (double)2.0));
        Assertions.assertEquals((long)6500L, (long)ThrottledInputStream.toSleepMillis((long)15L, (long)1000L, (double)2.0));
        Assertions.assertEquals((long)4000L, (long)ThrottledInputStream.toSleepMillis((long)5L, (long)1000L, (double)1.0));
        Assertions.assertEquals((long)9000L, (long)ThrottledInputStream.toSleepMillis((long)5L, (long)1000L, (double)0.5));
        Assertions.assertEquals((long)99000L, (long)ThrottledInputStream.toSleepMillis((long)5L, (long)1000L, (double)0.05));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)1L, (long)1000L, (double)2.0));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)2L, (long)2000L, (double)2.0));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)1L, (long)1000L, (double)2.0));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)1L, (long)1000L, (double)2.0));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)1L, (long)1000L, (double)1.0));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)1L, (long)1000L, (double)1.0));
    }

    @Test
    void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException(ThrottledInputStream.builder());
    }

    @Override
    protected void testEos(ThrottledInputStream inputStream) {
        Assertions.assertEquals((long)3L, (long)inputStream.getByteCount());
    }

    @Test
    void testGet() throws IOException {
        try (ThrottledInputStream inputStream = this.createFixture();){
            inputStream.read();
            Assertions.assertEquals((Object)Duration.ZERO, (Object)inputStream.getTotalSleepDuration());
        }
    }

    private static /* synthetic */ void lambda$testAfterReadConsumer$2(InputStream inputStream) throws Throwable {
        IOUtils.consume((InputStream)inputStream);
    }
}

