/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.MemoryMappedFileInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class MemoryMappedFileInputStreamTest {
    @TempDir
    Path tempDir;

    MemoryMappedFileInputStreamTest() {
    }

    @AfterEach
    public void afterEach() {
        System.gc();
        Thread.yield();
        System.runFinalization();
        Thread.yield();
        System.gc();
        Thread.yield();
        System.runFinalization();
        Thread.yield();
    }

    private Path createTestFile(int size) throws IOException {
        return Files.write(Files.createTempFile(this.tempDir, null, null, new FileAttribute[0]), RandomUtils.insecure().randomBytes(size), new OpenOption[0]);
    }

    private MemoryMappedFileInputStream newInputStream(Path file) throws IOException {
        return ((MemoryMappedFileInputStream.Builder)MemoryMappedFileInputStream.builder().setPath(file)).get();
    }

    private MemoryMappedFileInputStream newInputStream(Path file, int bufferSize) throws IOException {
        return ((MemoryMappedFileInputStream.Builder)((MemoryMappedFileInputStream.Builder)MemoryMappedFileInputStream.builder().setPath(file)).setBufferSize(bufferSize)).get();
    }

    @Test
    void testAlternateBufferSize() throws IOException {
        Path file = this.createTestFile(0x100000);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 1024);){
            Assertions.assertArrayEquals((byte[])expectedData, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    void testAvailableAfterClose(int len) throws Exception {
        MemoryMappedFileInputStream shadow;
        Path file = this.createTestFile(len);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 1024);){
            Assertions.assertEquals((int)0, (int)inputStream.available());
            shadow = inputStream;
        }
        Assertions.assertEquals((int)0, (int)shadow.available());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    void testAvailableAfterOpen(int len) throws Exception {
        Path file = this.createTestFile(len);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 1024);){
            Assertions.assertEquals((int)0, (int)inputStream.available());
            inputStream.read();
            Assertions.assertEquals((int)Math.max(len - 1, 0), (int)inputStream.available());
            IOUtils.toByteArray((InputStream)inputStream);
            Assertions.assertEquals((int)0, (int)inputStream.available());
        }
    }

    @Test
    void testEmptyFile() throws IOException {
        Path file = this.createTestFile(0);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file);){
            Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    void testLargerFile() throws IOException {
        Path file = this.createTestFile(0x100000);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file);){
            Assertions.assertArrayEquals((byte[])expectedData, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    void testReadAfterClose() throws IOException {
        Path file = this.createTestFile(0x100000);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 1024);){
            inputStream.close();
            Assertions.assertThrows(IOException.class, () -> MemoryMappedFileInputStreamTest.lambda$testReadAfterClose$0((InputStream)inputStream));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    void testReadAfterClose(int len) throws Exception {
        Path file = this.createTestFile(len);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 1024);){
            inputStream.close();
            Assertions.assertThrows(IOException.class, ((InputStream)inputStream)::read);
        }
    }

    @Test
    void testReadSingleByte() throws IOException {
        Path file = this.createTestFile(2);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 1024);){
            int b1 = inputStream.read();
            int b2 = inputStream.read();
            Assertions.assertEquals((int)-1, (int)inputStream.read());
            Assertions.assertArrayEquals((byte[])expectedData, (byte[])new byte[]{(byte)b1, (byte)b2});
        }
    }

    @Test
    void testSkipAtStart() throws IOException {
        Path file = this.createTestFile(100);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 10);){
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedData, 1, expectedData.length), (byte[])data);
        }
    }

    @Test
    void testSkipEmpty() throws IOException {
        Path file = this.createTestFile(0);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file);){
            Assertions.assertEquals((long)0L, (long)inputStream.skip(5L));
            Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    void testSkipInCurrentBuffer() throws IOException {
        Path file = this.createTestFile(100);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 10);){
            IOUtils.toByteArray((InputStream)inputStream, (int)5);
            Assertions.assertEquals((long)3L, (long)inputStream.skip(3L));
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedData, 8, expectedData.length), (byte[])data);
        }
    }

    @ParameterizedTest
    @ValueSource(ints={-5, -1, 0})
    void testSkipNoop(int amountToSkip) throws IOException {
        Path file = this.createTestFile(10);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file);){
            Assertions.assertEquals((long)0L, (long)inputStream.skip(amountToSkip));
            Assertions.assertArrayEquals((byte[])expectedData, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    void testSkipOutOfCurrentBuffer() throws IOException {
        Path file = this.createTestFile(100);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 10);){
            IOUtils.toByteArray((InputStream)inputStream, (int)5);
            Assertions.assertEquals((long)6L, (long)inputStream.skip(6L));
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedData, 11, expectedData.length), (byte[])data);
        }
    }

    @Test
    void testSkipPastEof() throws IOException {
        Path file = this.createTestFile(100);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 10);){
            IOUtils.toByteArray((InputStream)inputStream, (int)5);
            Assertions.assertEquals((long)95L, (long)inputStream.skip(96L));
            Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    void testSkipToEndOfCurrentBuffer() throws IOException {
        Path file = this.createTestFile(100);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file, 10);){
            IOUtils.toByteArray((InputStream)inputStream, (int)5);
            Assertions.assertEquals((long)5L, (long)inputStream.skip(5L));
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedData, 10, expectedData.length), (byte[])data);
        }
    }

    @Test
    void testSkipToEndOfCurrentBufferBuilder() throws IOException {
        Path file = this.createTestFile(100);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = ((MemoryMappedFileInputStream.Builder)((MemoryMappedFileInputStream.Builder)MemoryMappedFileInputStream.builder().setPath(file)).setBufferSize(10)).get();){
            Assertions.assertEquals((int)10, (int)inputStream.getBufferSize());
            IOUtils.toByteArray((InputStream)inputStream, (int)5);
            Assertions.assertEquals((long)5L, (long)inputStream.skip(5L));
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedData, 10, expectedData.length), (byte[])data);
        }
    }

    @Test
    void testSmallFileBuilder() throws IOException {
        Path file = this.createTestFile(100);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = ((MemoryMappedFileInputStream.Builder)MemoryMappedFileInputStream.builder().setFile(file.toFile())).get();){
            Assertions.assertArrayEquals((byte[])expectedData, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    void testSmallPath() throws IOException {
        Path file = this.createTestFile(100);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = this.newInputStream(file);){
            Assertions.assertArrayEquals((byte[])expectedData, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    void testSmallPathBuilder() throws IOException {
        Path file = this.createTestFile(100);
        byte[] expectedData = Files.readAllBytes(file);
        try (MemoryMappedFileInputStream inputStream = ((MemoryMappedFileInputStream.Builder)MemoryMappedFileInputStream.builder().setPath(file)).get();){
            Assertions.assertArrayEquals((byte[])expectedData, (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    private static /* synthetic */ void lambda$testReadAfterClose$0(InputStream inputStream) throws Throwable {
        IOUtils.toByteArray((InputStream)inputStream);
    }
}

