/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.resolver.CatalogResolver;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.EntityResolver;

public class TestCatalogResolver {
    private static final String CATALOG_FILES = "catalog.xml";
    private static final String PUBLIC_FILE = "testResolver.xml";
    private static final String REWRITE_SYSTEM_FILE = "test.properties.xml";
    private static final String REWRITE_SCHEMA_FILE = "sample.xml";
    private CatalogResolver resolver;
    private XMLConfiguration config;

    private void load(String fileName) throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.load(fileName);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.resolver = new CatalogResolver();
        this.resolver.setCatalogFiles(CATALOG_FILES);
        this.config = new XMLConfiguration();
        this.config.setEntityResolver((EntityResolver)this.resolver);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.resolver = null;
        this.config = null;
    }

    @Test
    void testDebug() throws Exception {
        this.resolver.setDebug(true);
    }

    @Test
    void testLogger() throws Exception {
        ConfigurationLogger log = new ConfigurationLogger(this.getClass());
        this.resolver.setLogger(log);
        Assertions.assertNotNull((Object)this.resolver.getLogger());
        Assertions.assertSame((Object)log, (Object)this.resolver.getLogger());
    }

    @Test
    void testPublic() {
        Assertions.assertDoesNotThrow(() -> this.load(PUBLIC_FILE));
    }

    @Test
    void testRewriteSystem() {
        Assertions.assertDoesNotThrow(() -> this.load(REWRITE_SYSTEM_FILE));
    }

    @Test
    void testSchemaResolver() {
        Assertions.assertDoesNotThrow(() -> this.load(REWRITE_SCHEMA_FILE));
    }
}

