/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="updatecidrgroup", description="Insert/Update a cidr group")
public class UpdateCIDRGroup
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<cidrGroup> <cidr> ...]", description="Requires a cidr group name, followed by one or more CIDRs separated by space")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument((this.args.size() > 1 ? 1 : 0) != 0, (Object)"updatecidrgroup command requires a cidr group name and atleast one CIDR");
        String cidrGroupName = this.args.get(0);
        try {
            probe.updateCidrGroup(cidrGroupName, new ArrayList<String>(this.args.subList(1, this.args.size())));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

