/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import javax.annotation.Nullable;

public final class HttpProtocolUtil {
    @Nullable
    public static String getProtocol(@Nullable String protocol) {
        if (protocol != null && protocol.startsWith("HTTP/")) {
            return "http";
        }
        return null;
    }

    @Nullable
    public static String getVersion(@Nullable String protocol) {
        if (protocol != null && protocol.startsWith("HTTP/")) {
            return HttpProtocolUtil.normalizeHttpVersion(protocol.substring("HTTP/".length()));
        }
        return null;
    }

    public static String normalizeHttpVersion(String version) {
        if ("2.0".equals(version)) {
            return "2";
        }
        return version;
    }

    private HttpProtocolUtil() {
    }
}

