/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.PooledObjectFactory;
import org.apache.camel.support.service.ServiceSupport;

public abstract class PooledObjectFactorySupport<T>
extends ServiceSupport
implements PooledObjectFactory<T> {
    protected final Object source;
    protected UtilizationStatistics statistics;
    protected CamelContext camelContext;
    protected BlockingQueue<T> pool;
    protected int capacity = 100;
    protected boolean statisticsEnabled;

    public PooledObjectFactorySupport() {
        this.source = null;
    }

    public PooledObjectFactorySupport(Object source) {
        this.source = source;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        if (this.isPooled()) {
            this.pool = new ArrayBlockingQueue<T>(this.capacity);
        }
        if (this.isStatisticsEnabled()) {
            this.statistics = new UtilizationStatistics();
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public int getSize() {
        if (this.pool != null) {
            return this.pool.size();
        }
        return 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void resetStatistics() {
        if (this.statistics != null) {
            this.statistics.reset();
        }
    }

    public boolean isPooled() {
        return true;
    }

    public void purge() {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    public PooledObjectFactory.Statistics getStatistics() {
        return this.statistics;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.statistics != null) {
            this.statistics.reset();
            this.statistics = null;
        }
        if (this.pool != null) {
            this.pool.clear();
            this.pool = null;
        }
    }

    protected static final class UtilizationStatistics
    implements PooledObjectFactory.Statistics {
        public final LongAdder created = new LongAdder();
        public final LongAdder acquired = new LongAdder();
        public final LongAdder released = new LongAdder();
        public final LongAdder discarded = new LongAdder();

        protected UtilizationStatistics() {
        }

        public void reset() {
            this.created.reset();
            this.acquired.reset();
            this.released.reset();
            this.discarded.reset();
        }

        public long getCreatedCounter() {
            return this.created.longValue();
        }

        public long getAcquiredCounter() {
            return this.acquired.longValue();
        }

        public long getReleasedCounter() {
            return this.released.longValue();
        }

        public long getDiscardedCounter() {
            return this.discarded.longValue();
        }
    }
}

